
One of the more frequent tasks when working with strings is to determine whether one string is a part (substring) of another string. Most programming languages have a built-in function for this very task. In PHP, there's no such function, we imitate it by using [mb_strpos()](https://www.php.net/manual/en/function.mb-strpos.php). This function searches for the position of the first occurrence of one string in another.

```php
<?php

if (mb_strpos('Валар Моргулис', 'Morgulis')) { // 6
    // ...
}
```

In the example above, the function will return 6, which corresponds to the index of the letter M.

```php
<?php

if (mb_strpos('Valar Morghulis', 'Valar')) { // 0
    // ...
}
```

And in this example, it returns `0`, which corresponds to the first letter of the string. There's a mistake often made by beginners in this kind of code. In PHP `0` is treated as `false`, а значит, условие не выполнится. Правильная проверка выглядит так:

```php
<?php

if (mb_strpos('Valar Morghulis', 'Valar') !== false) {
    // ...
}
```

The `mb_strpos()` function returns `false` if no substring was found, so you can use a strict comparison with `false`.
