Глобализация проявляется во многих аспектах, в том числе в единой системе мер: время, размеры и расстояния, температуры, даты и многое другое.

Конечно, есть страны, которые выпадают из общего потока. Например, США — это чуть ли не единственная страна, в которой сохраняется и превалирует [английская система мер](https://ru.wikipedia.org/wiki/Английская_система_мер). США использует мили вместо километров и фунты вместо килограммов. Во многих восточных странах по-другому устроены календари, и где-то сейчас идет четырехтысячный год. Но в целом все унифицировано.

Несмотря на эту унификацию, в каждой стране есть свои особенности по способу записи, сравнению и другим аспектам. Например, в США принято в датах первым ставить месяц, а вторым — день. В некоторых странах для вывода вещественных чисел используют точку, а в некоторых — запятую: `1,234`.

Эти особенности необязательно привязаны к целой стране. Внутри одной страны может быть множество дополнительных разделений. Каждый такой набор особенностей называют **локалью**, а процесс адаптации к особенностям конкретной локали — **локализацией**.

Локализация важна в программном обеспечении. Пользователь всегда ожидает, что любой софт или сайт будет работать предсказуемо. В это понятие включается и локализация. Понятно, что самостоятельное решение этой задачи слишком затратно. К счастью, этого делать не нужно. Локализация обычно встроена в сам язык или в специальные библиотеки.

В PHP для управления локалью используется функция [setlocale()](https://secure.php.net/manual/ru/function.setlocale.php). Эта функция настраивает локаль глобально. Ее вызов влияет на все последующие функции, опирающиеся на локализацию:

```php
setlocale(int $category, string $locales, string ...$rest): string|false
```

Первым параметром эта функция принимает название категории (как константу), к которой нужно применить локаль, передающуюся в параметрах дальше:

* LC_ALL — все нижеперечисленное
* LC_COLLATE — функции сравнения строк `strcoll()`
* LC_CTYPE — функции преобразования и классификации строк, например, `strtoupper()`
* LC_MONETARY — для функции `localeconv()`
* LC_NUMERIC — задает символ десятичного разделения `localeconv()`
* LC_TIME — форматирование даты и времени функцией `strftime()`

Изучим на примере, как установленная локаль влияет на отображение данных:

```php
<?php

print_r(1.234); // => 1.234
setlocale(LC_NUMERIC, 'ru_RU');
print_r(1.234); // => 1,234
```

Попробуем вторым аргументом передать `0` вместо локали: `setlocale(LC_ALL, 0)`. В таком случае функция будет возвращать текущую установленную локаль для категории.
