Цикл `while` идеален для ситуаций, когда количество итераций неизвестно заранее — например, при поиске простого числа. Когда количество итераций известно, предпочтительнее использовать цикл `for`. Именно его мы изучим в этом уроке.

Посмотрим реализацию переворота строки через цикл `for`:

```php
<?php

function reverseString($str)
{
    $result = '';

    for ($i = 0; $i < strlen($str); $i += 1) {
        $currentChar = $str[$i];
        $result = "{$currentChar}{$result}";
    }

    return $result;
}
```

https://replit.com/@hexlet/php-basics-for-reversestring

Этот код можно прочитать так:

> Цикл с индексом `$i` повторяется, пока соблюдается условие `$i < strlen($str)`, и после каждого шага `$i` увеличивается на 1

Посмотрим, что находится в круглых скобках:

1. Начальное значение счетчика — этот код выполняется ровно один раз перед первой итерацией
2. Предикат (условие повторения циклов) — выполняется на каждой итерации, как и в `while`
3. Описание изменения счетчика — этот код выполняется в конце каждой итерации

В остальном принцип работы точно такой же, как у цикла `while`.
