Из языка Си в PHP перекочевали две операции:

* Инкремент `++`
* Декремент `--`

Они очень часто встречаются вместе с циклами. Эти унарные операции увеличивают и уменьшают на единицу число, записанное в переменную:

```php
<?php

$i = 0;
$i++; // 0
$i++; // 1

$i--; // 2
$i--; // 1
```

При использовании префиксной формы все происходит наоборот. Сначала идет изменение переменной, а затем — возврат нового значения:

```php
<?php

$i = 0;
++$i; // 1
++$i; // 2

--$i; // 1
--$i; // 0
```

Кажется, что нет никакой разницы между постфиксной и префиксной формами. Но тут начинаются сложности. Все остальные операции не имеют побочных эффектов и просто возвращают новое значение. В отличие от них, инкремент и декремент не только возвращают значение, но и **изменяют** значение переменной.

При использовании префиксной нотации сначала происходит изменение переменной, а потом — возврат. При использовании постфиксной нотации — наоборот: сначала возврат, а потом изменение переменной.

Правило работает одинаково для инкремента и декремента. Для простоты рассмотрим только инкремент:

```php
<?php

$x = 5;

echo ++$x; // => 6
echo $x;   // => 6

echo $x++; // => 6
echo $x;   // => 7
```

Обсудим, что пошагово происходит в коде:

1. Вывели на экран `++$x` — это префиксный инкремент, поэтому сначала значение переменной увеличилось на 1, потом результат вернулся и вывелся на экран
2. Значение изменилось, поэтому `echo $x` вывел 6
3. Теперь выводим на экран `$x++` — это постфиксный инкремент, поэтому сначала значение вернулось и вывелось на экран, а потом переменная увеличилась на 1
4. Значение изменилось, поэтому `echo $x` вывел 7

Инкремент и декремент могут заметно усложнить код. Особенно сложно все становится, когда мы вставляем инкремент внутрь других операций: `$x = $i++ - 7 + --$h`.

Понять такой код невозможно, поэтому лучше не использовать такие конструкции. Например, в языке JavaScript при проверке кода линтер сразу начинает ругаться, когда видит использование инкремента и декремента.

Мы советуем пользоваться этими конструкциями так:

* В рамках одного выражения никогда не смешивайте функции без побочных эффектов с функциями с побочными эффектами (то же самое касается операций)
* Используйте инкремент и декремент только там, где нет разницы между префиксным и постфиксным вариантом: отдельно от всего, на своей собственной строчке кода
