В этом уроке мы реализуем функцию `mysubstr()`, которая извлекает из строки подстроку указанной длины.

Она принимает на вход два аргумента:

* Строку
* Длину

Эта функция возвращает подстроку, начиная с первого символа:

```php
<?php

function mysubstr($str, $length)
{
    $index = 0;
    $result = '';
    while ($index < $length) {
        $currentChar = $str[$index];
        $result = "{$result}{$currentChar}";
        $index = $index + 1;
    }

    return $result;
}

$str = 'If I look back I am lost';

mysubstr($str, 1); // 'I'
mysubstr($str, 7); // 'If I lo'
```

https://replit.com/@hexlet/php-basics-edge-cases-mysubstr

Кажется, что все хорошо. Но наша функция содержит множество ошибок, потому что в ней не учтены так называемые **пограничные случаи**. Функция нормально работает только с нормальными аргументами. Но мы не знаем, как она поведет себя, если передать ей такие варианты длины:

* `0`
* Отрицательное число
* Число, превышающее реальный размер строки

Функция `mysubstr()` не рассчитана на такие варианты. Можно подумать, что это не проблема: функция работает в нормальных условиях, и просто не нужно передавать ей «плохие аргументы».

В идеальном мире — да, но в реальном мире ваш код будет запускаться в разных ситуациях, с разными комбинациями условий и данных. Нельзя быть уверенным, что аргументы всегда будут корректными, поэтому нужно учитывать все случаи, в рамках здравого смысла.

Пограничные случаи — самая распространенная причина логических ошибок в программах. Программисты часто забывают что-нибудь учесть. Такие ошибки часто проявляются не сразу, и могут долгое время не приводить к видимым проблемам. Программа продолжает работать, но в какой-то момент обнаруживается, что в результатах есть ошибки.

Часто причина заключается в слабой типизации PHP. Умение справляться с такими ошибками приходит с опытом, через постоянные проблемы в стиле «Ой, забыл проверить на пустую строку!».

Давайте представим себе расширенную функцию `mysubstr()`. Она принимает три аргумента:

* Строку
* Индекс
* Длину извлекаемой подстроки

Функция возвращает подстроку указанной длины начиная с указанного индекса. Посмотрим примеры вызова:

```php
<?php

$str = 'If I look back I am lost';
mysubstr($str, 0, 1); // 'I'
mysubstr($str, 3, 6); // 'I look'
```

Обсудим, что может пойти не так. Какие **пограничные случаи** стоит учитывать:

* Отрицательная длина извлекаемой подстроки
* Отрицательный заданный индекс
* Заданный индекс выходит за границу всей строки
* Длина подстроки в сумме с заданным индексом выходит за границу всей строки

В реализации функции каждый пограничный случай будет отдельным куском кода, скорее всего реализованным с помощью `if`.

Чтобы написать функцию `mysubstr()` и защититься от этих случаев, стоит написать отдельную функцию, которая будет проверять аргументы на корректность. Займемся этим в задании к этому уроку.
