
The `mysubstr()`, function you implemented in the last lesson contains many errors. "But it passed the tests!" Yes, but there were no **edge cases** in these checks. The function worked fine with normal arguments, but how would it behave if you gave it these length options?

* `0`
* A negative number
* A number larger than the actual string size

The `mysubstr()` function isn't designed for this. You might think that this isn't a problem: the function works under normal conditions, and you simply need to not pass "bad" arguments to it. In a perfect world, yes, but in the real world your code might run in different situations, with different combinations of conditions and data. You can't be sure that arguments will always be correct, so you have to consider all cases, within the bounds of common sense.

Boundary errors are the most common cause of logical errors in programs. There's always something that programmers forget to take into account. These errors often don't manifest themselves immediately, and may not lead to visible problems for a long time. The program may continue to work, but at some point someone might notice an error in the results. Often, the reason is PHP's weak typing.

The ability to deal with such errors comes with experience, through constant "oops, forgot to check for an empty string!"-type screw-ups.

---

Let's imagine an extended version of the `mysubstr()` function. It takes three arguments; a string, an index, and the length of the substring to be extracted. The function returns a substring of the specified length starting from the specified index. Call examples:

```php
<?php

$str = 'If I look back I am lost';
mysubstr($str, 0, 1); // 'I'
mysubstr($str, 3, 6); // 'I look'
```

Let's figure out what could go wrong. What edge cases are worth considering:

* The substring extracted has a negative length
* The index set is negative
* The index set exceeds the boundary of the whole string
* The length of the substring plus the given index exceeds the boundary of the whole string

When the function is implemented, each edge case will be a separate piece of code, most likely implemented with an `if`.

If you want to write a `mysubstr()` function that's protected against these cases, it's worth writing a separate function that will check the arguments for correctness. We'll get to that in the assignment.
