Еще одно использование циклов – формирование строк. Подобная задача нередко встречается в веб-программировании. Она сводится к обычной агрегации с применением интерполяции или конкатенации.

Есть одна задача, крайне популярная на собеседованиях — это **переворот строки**. Ее можно решить множеством разных способов, но именно посимвольный перебор считается базовым.

Рассмотрим пример работы этой функции:

```php
<?php

reverse('Hexlet'); // telxeH
```

Общая идея переворота состоит в следующем — нужно брать символы по очереди с начала строки и соединять их в обратном порядке. Звучит довольно просто. Давайте проверим:

```php
<?php

function reverse($str)
{
    $i = 0;
    // Нейтральный элемент для строк — это пустая строка
    $result = '';

    while ($i < strlen($str)) {
        $currentChar = $str[$i];
        // Соединяем в обратном порядке
        $result = "{$currentChar}{$result}";
        // Тоже самое через конкатенацию
        // $result = $currentChar . $result;
        $i = $i + 1;
    }

    return $result;
}

$name = 'Bran';
reverse($name); // 'narB'
// Проверка нейтрального элемента
reverse(''); // ''
```

https://replit.com/@hexlet/php-basics-loops-using-reverse

Единственный сложный момент в этом коде – прочувствовать, как собирается сама строка. Так как каждый следующий символ прикрепляется к результирующей строке слева, то, в конечном итоге, строка оказывается перевернута.
