Программы, которые мы пишем, становятся все сложнее и объемнее. Они все еще очень далеки от реальных программ, где количество строк кода измеряется десятками и сотнями тысяч. Текущая сложность уже способна заставить напрячься людей без опыта. Начиная с этого урока, мы переходим к одной из самых сложных базовых тем в программировании – **циклам**.

Любые прикладные программы служат прагматичным целям. Они помогают управлять сотрудниками и финансами, развлекают, в конце концов. Несмотря на различия, все эти программы выполняют заложенные в них алгоритмы, которые похожи между собой. Что это такое? **Алгоритм** — это последовательность действий или инструкций, которая приводит нас к некоему ожидаемому результату. Это описание подходит под любую программу, но под алгоритмами обычно понимается что-то более специфичное.

Представьте себе, что у нас есть книга, и мы хотим найти внутри нее какую-то конкретную фразу. Саму фразу мы помним, но не знаем, на какой она странице. Как найти нужную страницу? Самый простой и долгий способ — последовательно просматривать страницы до тех пор, пока мы не найдем нужную фразу. В худшем случае придется просмотреть все страницы, но результат мы все равно получим. Именно этот процесс и называется **алгоритмом**. Он включает в себя перебор страниц и логические проверки, нашли мы фразу или нет.

Заранее неизвестно количество страниц, которое придется посмотреть, но сам процесс просмотра повторяется из раза в раз совершенно одинаково. Для выполнения таких повторяющихся действий как раз и нужны **циклы**. Каждый такой повтор называется **итерацией**.

Допустим, мы хотим написать функцию, которая выводит на экран все числа от единицы до указанного (через аргументы):

```php
<?php

printNumbers(3);
// => 1
// => 2
// => 3
```

Эту функцию невозможно реализовать уже изученными средствами, так как количество выводов на экран заранее не известно. А с циклами это не составит никаких проблем:

```php
<?php

function printNumbers($lastNumber)
{
    // Переменная i — это сокращение от index (порядковый номер)
    // Он используется по общему соглашению во множестве языков
    // в качестве счетчика цикла
    $i = 1;

    while ($i <= $lastNumber) {
        print_r($i);
        print_r("\n");
        $i = $i + 1;
    }
    print_r('finished!');
}

printNumbers(3);
// => 1
// => 2
// => 3
// => finished!
```

https://replit.com/@hexlet/php-basics-while

В коде функции использован цикл `while`. Он состоит из трех элементов:

* Ключевое слово `while` — несмотря на схожесть с вызовом функций, это не вызов функции
* Предикат — условие, которое указывается в скобках после `while` и вычисляется на каждой итерации
* Тело цикла — блок кода в фигурных скобках

Конструкция читается так: «делать то, что указано в теле цикла, пока истинно условие `$i <= $lastNumber`».

Разберем работу этого кода для вызова `printNumbers(3)`:

```php
<?php

// Инициализируется переменная i
$i = 1;

// Предикат возвращает true, поэтому выполняется тело цикла
while (1 <= 3)
// print_r(1);
// $i = 1 + 1;

// Закончилось тело цикла, поэтому происходит возврат в начало
while (2 <= 3)
// print_r(2);
// $i = 2 + 1;

// Закончилось тело цикла, поэтому происходит возврат в начало
while (3 <= 3)
// print_r(3);
// $i = 3 + 1;

// Предикат возвращает false, поэтому выполнение переходит за цикл
while (4 <= 3)

// print_r('finished!');
// На этом этапе i равен 4, но он нам уже не нужен
// Функция завершается
```

Самое главное в цикле — завершение его работы (выход из цикла). Процесс, который порождает цикл, должен в конце концов остановиться. Ответственность за остановку полностью лежит на программисте.

Обычно задача сводится к введению переменной, называемой **счетчиком цикла**. Сначала счетчик инициализируется, то есть ему задается начальное значение. В нашем примере это инструкция `$i = 1`, выполняемая до входа в цикл. Затем в условии цикла проверяется, достиг ли счетчик своего предельного значения. И, наконец, счетчик меняет свое значение `$i = $i + 1`.

На этом моменте новички делают больше всего ошибок. Например, случайно забытое увеличение счетчика или неправильная проверка в предикате способны привести к **зацикливанию**. Это ситуация, при которой цикл работает бесконечно, и программа никогда не останавливается.

В таком случае приходится ее завершать принудительно:

```php
<?php

function printNumbers($lastNumber)
{
    $i = 1;

    // Этот цикл никогда не остановится
    // Он будет печатать всегда одно значение
    while ($i <= $lastNumber) {
        print_r($i);
    }
    print_r('finished!');
}
```

В некоторых случаях бесконечные циклы полезны. Здесь мы такие случаи не рассматриваем, но полезно знать, как выглядит такой код:

```php
<?php

while (true) {
    // Что-то делаем
}
```

Подведем итог. Когда все же нужны циклы, а когда можно обойтись без них? Физически невозможно обойтись без циклов, когда алгоритм решения задачи требует повторения каких-то действий и количество этих операций заранее неизвестно — как в нашем примере с книгой.
