Задача предиката — получить ответ на вопрос, но обычно этого недостаточно и нужно выполнить определенное действие в зависимости от ответа.

Напишем функцию, которая определяет тип переданного предложения. Для начала она будет отличать обычные предложения от вопросительных:

```php
<?php

function getTypeOfSentence($sentence)
{
    // Простой способ извлечь последний символ
    $lastChar = $sentence[-1];
    if ($lastChar === '?') {
        return 'question';
    }

    return 'normal';
}

getTypeOfSentence('Hodor');  // normal
getTypeOfSentence('Hodor?'); // question
```

`if` — это инструкция. В скобках ей передается выражение-предикат, а затем описывается блок кода в фигурных скобках. Этот блок кода будет выполнен, только если предикат — истина. Если предикат — ложь, то блок кода в фигурных скобках пропускается, и функция продолжает свое выполнение дальше.

В нашем случае следующая строчка кода — `return 'normal';`. Она заставит функцию вернуть строку и завершиться. Как видите, `return` может находиться где угодно в функции, в том числе — внутри блока кода с условием.
