Напомним, что PHP — это язык со **слабой типизацией**:

* Он знает о существовании разных типов (числа, строки и так далее)
* При этом он относится к их использованию не очень строго, пытаясь преобразовывать информацию, когда это кажется разумным

Особенно много автоматических преобразований происходит при работе с логическими операциями. В PHP есть два простых правила, по которым происходят преобразования:

* `0`, `null` и пустая строка `''` приводятся к `false`, поэтому эти значения называют *falsy*
* Все остальное превращается в `true`

Это работает и в другую сторону. И `true`, и `false` преобразовываются в другие типы данных в зависимости от ситуации:

```php
<?php

print_r(true);   // => 1
print_r(false);  // => (на экран выводится пустая строка)
print_r(0 || 1); // => 1
```

Оператор **ИЛИ** работает только с типом *bool*, но ему даны числа `1` и `0`:

1. `0` преобразуется в `false`, а `1` преобразуется в `true`
2. Результат `false || true` — это `true`
3. Теперь `print_r()` получает `true`, но он работает только со строками
4. `true` преобразуется в `1`
5. И на экран выводится `1`

Здесь важно отметить также отличие операторов `===` и `==`. Оно как раз заключается в преобразовании типов.

Пустая строка и `false` — это разные значения, поэтому оператор `===` говорит «Ложь! Они не равны!».

Но оператор `==` преобразует типы. С его точки зрения, пустая строка и `false` равны. Это преобразование неявное, поэтому по возможности избегайте операторов `==` и `!=`:

```php
<?php

var_dump('' === false); // => false
var_dump('' == false);  // => true
```

Вспомним операцию отрицания. При двойном отрицании `!!` итоговое значение равно начальному:

```php
<?php

$answer = true;
var_dump(!$answer);  // => false
var_dump(!!$answer); // => true
```

Здесь также дополнительно происходят преобразования типа. Поэтому результатом двойного отрицания всегда будет _bool_. Этим приемом пользуются, чтобы поменять тип данных.

В разных языках программирования разные правила преобразований. Некоторые языки вообще не преобразовывают типы сами.
