
Логические операторы — важная тема, поэтому стоит закрепить её дополнительным примером и упражнением.

Попробуем реализовать функцию, проверяющую год на високосность. Год будет високосным, если он кратен 400 или он одновременно кратен 4 и не кратен 100. Как видите, в определении уже заложена вся необходимая логика, осталось только переложить её на код:

```php
<?php

function isLeapYear($year)
{
    return $year % 400 === 0 || ($year % 4 === 0 && $year % 100 !== 0);
}

isLeapYear(2018); // false
isLeapYear(2017); // false
isLeapYear(2016); // true
```

Разберём по частям:

- первое условие `$year % 400 === 0`: остаток от деления на 400 равен 0, значит, число кратно 400
- `||` **ИЛИ**
- второе условие `($year % 4 === 0 && $year % 100 !== 0)`
    - `year % 4 === 0`: остаток от деления на 4 равен 0, значит, число кратно 4
    - `&&` **И**
    - `$year % 100 !== 0`: остаток от деления на 100 не равен 0, значит, число не кратно 100
