Наряду с конъюнкцией (И) и дизъюнкцией (ИЛИ), часто используется операция «отрицание». Отрицание меняет логическое значение на противоположное.

В программировании ему соответствует унарный оператор `!`. Если есть функция, проверяющая четность числа, то с помощью отрицания можно выполнить проверку нечетности:

```php
<?php

function isEven($number)
{
    return $number % 2 === 0;
}

isEven(10);  // true
!isEven(10); // false
// В логике двойное отрицание подобно отсутствию отрицания вообще
!!isEven(10); // true
```

Мы просто добавили `!` слева от вызова функции и получили обратное действие. Отрицание — мощный инструмент, который позволяет лаконично выражать задуманные правила в коде без необходимости писать новые функции.
