**Логические операции** — это выражения, значит, их можно комбинировать с другими выражениями. Например, мы хотим проверить четность числа — кратность двум. В программировании используют такой подход: проверяют остаток от деления на два:

* если остаток `0` — число четное
* если остаток не `0` — число нечетное

Остаток от деления — простая, но важная концепция в арифметике, алгебре, в теории чисел и криптографии. Нужно разделить число на несколько равных групп, и если в конце что-то останется — это остаток от деления.

Делим конфеты поровну между людьми:

* 7 конфет, 2 человека: 2 x 3 + остаток 1 — 7 не кратно 2
* 21 конфету, 3 человека: 3 x 7 + остаток 0 — 21 кратно 3
* 19 конфет, 5 человек: 5 x 3 + остаток 4 — 19 не кратно 5

Оператор `%` вычисляет **остаток от деления**:

* `7 % 2` → `1`
* `21 % 3` → `0`
* `19 % 5` → `4`

С помощью него напишем функцию проверки четности:

```php
<?php

function isEven($number)
{
    return $number % 2 === 0;
}

isEven(10); // true
isEven(3);  // false
```

В одном выражении мы скомбинировали логический оператор проверки равенства `===` и арифметический оператор `%`.

Приоритет арифметических операций выше логических. Значит, сначала вычисляется арифметическое выражение `$number % 2`, затем результат участвует в логическом сравнении.

Это можно расшифровать так:

>«Вычислить остаток от деления числа `$number` на 2 и сравнить, равен ли остаток нулю; затем вернуть результат проверки равенства»*

---

*Напомним об извлечении символов из строки с помощью квадратных скобок:*

```php
<?php

$firstName = 'Alexander';

$firstName[0]; // A
```
