В программировании большое количество функций и методов имеют параметры, которые редко меняются. В таких случаях этим параметрам задают значения по умолчанию, которые можно поменять по необходимости. В этом уроке мы узнаем, как задавать значения по умолчанию. С помощью этого можно сократить количество одинакового кода:

```php
<?php

// Функция возведения в степень
// Второй параметр имеет значение по умолчанию 2
function myPow($x, $base = 2)
{
    return $x ** $base;
}

// Три во второй степени (двойка задана по умолчанию)
myPow(3); // 3 * 3 = 9
// Три в третьей степени
myPow(3, 3); // 3 * 3 * 3 = 27
```

Значение по умолчанию выглядит как обычное присваивание в определении. Оно срабатывает только в том случае, если параметр не передан. К этому нужно привыкнуть.

Значение по умолчанию может быть даже в том случае, когда параметр один:

```php
<?php

function myPrint($text = 'nothing')
{
    print_r($text);
}

myPrint(); // => "nothing"
myPrint("Hexlet"); // => "Hexlet"
```

Параметров со значениями по умолчанию может быть сколько угодно:

```php
<?php

function f($a = 5, $b = 10, $c = 100)
{
  ...
}
```

У значений по умолчанию есть одно ограничение. Они должны идти в самом конце списка параметров. С точки зрения синтаксиса невозможно создать функцию, у которой после необязательного параметра идет обязательный:

```php
<?php

// Такой код завершится с ошибкой
function f($a = 5, $b = 10, $c = 100, $x)
{
  ...
}

// И такой
function f($a = 5, $b = 10, $x, $c = 100)
{
  ...
}

// А вот такой сработает
function f($x, $a = 5, $b = 10, $c = 100)
{
  ...
}

// И такой
function f($x, $y, $a = 5, $b = 10, $c = 100)
{
  ...
}
```
