Функции могут не только возвращать значения, но и принимать их в виде параметров. С параметрами функций мы уже сталкивались:

```php
<?php

// Принимает на вход один параметр любого типа
print_r('я параметр');
// Принимает на вход два числовых параметра:
// Первый — округляемое число
// Второй — число знаков после запятой, которые нужно оставить
round(10.1245, 3); // 10.125
// Принимает на вход три строковых параметра:
// Первый — что ищем
// Второй — на что меняем
// Третий — строка, в которой производим замену
str_replace('go', 'mo', 'google'); // 'moogle'
```

В этом уроке мы научимся создавать функции, которые принимают на вход параметры. Представим, что перед нами стоит задача – реализовать функцию `getLastChar()`. Она возвращает последний символ в строке, переданной на вход как параметр. Вот как будет выглядеть использование этой функции:

```php
<?php

// Передача параметров напрямую без переменных
getLastChar('Hexlet'); // 't'
// Передача параметров через переменные
$name1 = 'Hexlet';
getLastChar($name1); // 't'
$name2 = 'Goo';
getLastChar($name2); // 'o'
```

Из описания и примеров кода мы можем сделать следующие выводы:

* Нам нужно определить функцию `getLastChar()`
* Функция должна принимать на вход один параметр строкового типа
* Функция должна возвращать значение строкового типа

Определение функции:

```php
<?php

function getLastChar($str)
{
    // Вычисляем индекс последнего символа как длина строки - 1
    return $str[strlen($str) - 1];
}
```

Разберем его. В скобках указывается имя параметра (`$str`). Так как внутри функции мы не знаем, с каким конкретно значением идет работа, то параметры всегда описываются как переменные.

Имя параметра может быть любым, оно не связано с тем, как вызывается функция. Главное, чтобы это имя отражало смысл значения, которое содержится внутри. Конкретное значение параметра будет зависеть от вызова этой функции.

Этот параметр является обязательным. Если попробовать вызвать функцию без него, то интерпретатор выдаст ошибку:

```sh
getLastChar(); // такой код не имеет смысла
ArgumentCountError: Too few arguments to function getLastChar(), 0 passed
```

Так же можно указывать два, три и более параметров. Они отделяются запятыми:

```php
<?php

// Функция по нахождению среднего числа
function average($x, $y)
{
    return ($x + $y) / 2;
}
average(1, 5); // 3
average(1, 2); // 1.5
```
