Реализуйте функцию `truncate()`, которая обрезает переданную в функцию строку до указанного количества символов, добавляет в конце троеточие и возвращает получившуюся строку. Подобная логика часто используется на сайтах, чтобы отобразить длинный текст в сокращенном виде. Функция принимает два параметра:

1. Строка, которую нужно обрезать
2. Число символов, которые нужно оставить

```php
// Передаём текст напрямую
// Обрезаем текст, оставляя 2 символа
truncate('hexlet', 2)  // 'he...'

// Через переменную
$text = 'it works!'
// Обрезаем текст, оставляя 4 символа
$result = truncate($text, 4);
print_r($result); // => 'it w...'
```

Реализовать эту функцию можно различными способами, подскажем лишь один из них. Для решения этим способом вам понадобится взять подстроку из строки, переданной первым параметром в функцию `truncate()`. Используйте для этого функцию [substr()](https://www.php.net/manual/ru/function.substr.php). Подумайте, исходя из задания, с какого индекса и какой длины вам надо извлечь подстроку?

  ```php
  <?php
  $word = 'welcome';
  // Передавать параметры в функцию можно через переменные
  $length = 3;
  substr($word, 0, $length); // 'wel'
  ```

С точки зрения проверочной системы не имеет значения, каким из способов будет реализована функция `truncate()` внутри, главное – чтобы она выполняла поставленную задачу
