Напомним, что функции бывают встроенными и добавленными программистом. С первыми мы уже познакомились. А в этом уроке научимся создавать собственные.

Определение собственных функций значительно упрощает написание и поддержку программ. Функции позволяют объединять сложные операции в одну. Например, отправка письма на сайте — это достаточно сложный процесс. Он включает в себя взаимодействие с внешними системами.

Благодаря возможности определять функции, всю сложность можно скрыть за одной простой функцией:

```php
<?php

// Гипотетический пример
// Место откуда берется функция
namespace Some\Email\Package\send;

$email = 'support@hexlet.io';
$title = 'Помогите';
$body = 'Я написал историю успеха, как я могу получить скидку?';

// Один маленький вызов — и много логики внутри
send($email, $title, $body);
```

Внутри себя подобный вызов выполняет довольно много логики. Он соединяется с почтовым сервером, формирует правильный запрос на основе заголовка и тела сообщения. Затем он это отправляет и закрывает соединение.

Создадим первую функцию. Ее задача — вывести на экран приветствие:

```
Hello, Hexlet!
```

```php
<?php

// Определение функции
// Определение не вызывает и не выполняет функцию
// Мы лишь говорим, что теперь такая функция существует
function showGreeting()
{
  $text = 'Hello, Hexlet!';
  print_r($text);

}

// Вызов функции
showGreeting(); // => 'Hello, Hexlet!'
```

В отличие от обычных данных, функции выполняют действия, поэтому их имена практически всегда должны быть глаголами: «построить что-то», «нарисовать что-то», «открыть что-то».

Все, что описывается в фигурных скобках после имени функции, называется телом функции. Внутри тела можно описывать любой код. Можно сказать, что это маленькая самостоятельная программа, набор произвольных инструкций.

Тело выполняется в тот момент, когда запускается функция. Причем каждый вызов функции запускает тело независимо от других вызовов.

Тело функции может быть пустым:

```php
<?php

// Минимальное определение функции, которая ничего не делает
function noop() {}

noop(); // Вызов есть, а смысла нет
// Такая функция тоже бывает полезна,
// но это относится к продвинутым темам
```

Создание функции еще называют реализацией, определением и имплементацией. Такие слова часто встречаются на практике.

В задачах, в которых необходимо реализовать функцию, ее не нужно вызывать. Это делают автоматизированные тесты, которые проверяют работоспособность функции. Пример с вызовом показан выше, чтобы было понятно, как функция будет использоваться.
