PHP поставляется с набором полезных функций. Вместе они составляют **стандартную библиотеку**. Обычно в нее входят тысячи функций, которые невозможно выучить, что и не нужно делать. В этом уроке мы дадим рекомендации по работе с новыми функциями.

Подразумевается, что любой программист знает, где искать документацию по ним и примерно представляет себе, чего он хочет достичь. Поэтому программировать без интернета крайне сложно.

Часто новички не знают, куда нужно идти и что искать. Эти знания и навыки приходят с опытом. Во время обучения и работы они знакомятся с более интересными функциями, которые решают их задачи более удобным способом. Так они и пополняют свой арсенал.

Вот некоторые советы, как узнавать о новых функциях:

* Всегда нужно отслеживать, с каким типом данных идет работа. Необходимые функции можно найти в соответствующем разделе документации. Например, для работы со строками нужно изучать строковые функции
* Периодически нужно открывать раздел со стандартными функциями по изучаемой тематике. Нужно изучать их, сигнатуры и способы использования
* Необходимо часто читать чужой код, особенно, код библиотек, которые используются нами. Он всегда доступен на GitHub

Еще одна особенность функций PHP из стандартной библиотеки в том, что они доступны глобально. Их можно вызывать в любом месте программы. Правда это не работает с функциями, написанными самостоятельно.

Большинство функций стандартной библиотеки сосредоточено вокруг определенных функциональности или типа данных. Например, есть большой блок функций по обработке строк, с числами и так далее. По некоторым из них мы пройдемся в процессе обучения.
