PHP viene con un conjunto de funciones útiles. Juntas, forman la **biblioteca estándar**. Por lo general, incluye miles de funciones que no se pueden aprender todas, ni es necesario hacerlo. En esta lección, daremos recomendaciones sobre cómo trabajar con nuevas funciones.

Se supone que cualquier programador sabe dónde buscar la documentación y tiene una idea aproximada de lo que quiere lograr. Por lo tanto, programar sin internet es extremadamente difícil.

A menudo, los principiantes no saben a dónde ir ni qué buscar. Estos conocimientos y habilidades se adquieren con la experiencia. Durante el aprendizaje y el trabajo, se familiarizan con funciones más interesantes que resuelven sus problemas de una manera más conveniente. Así es como enriquecen su arsenal.

Aquí hay algunos consejos sobre cómo aprender sobre nuevas funciones:

* Siempre es necesario tener en cuenta el tipo de datos con el que se está trabajando. Las funciones necesarias se pueden encontrar en la sección correspondiente de la documentación. Por ejemplo, para trabajar con cadenas, es necesario estudiar las funciones de cadenas.
* De vez en cuando, es necesario abrir la sección de funciones estándar relacionadas con el tema que se está estudiando. Es necesario estudiarlas, sus firmas y formas de uso.
* Es necesario leer el código de otras personas con frecuencia, especialmente el código de bibliotecas que utilizamos. Siempre está disponible en GitHub.

Otra característica de las funciones de PHP de la biblioteca estándar es que están disponibles globalmente. Se pueden llamar en cualquier parte del programa. Sin embargo, esto no se aplica a las funciones escritas por uno mismo.

La mayoría de las funciones de la biblioteca estándar se centran en funcionalidades o tipos de datos específicos. Por ejemplo, hay un gran conjunto de funciones para el manejo de cadenas, números, etc. Algunas de ellas las veremos durante el proceso de aprendizaje.
