
PHP, like any other language, comes with a set of useful features. Altogether, they make up the so-called **standard library**. It usually contains thousands of functions you can't remember, and that you don't have to. It's assumed that any programmer knows where to look for their documentation and has a rough idea of what they want to achieve. And the rest is a matter of technique. Programming without the Internet is extremely difficult.

To newcomers, it often looks like this: "Go I know not whither and fetch I know not what". In other words, most people have no idea how to learn about these functions when they don't know anything at all. Oddly enough, there's no way to know everything you need to know once and for all. As you grow as a developer, you'll learn all the exciting features that can solve your problems more elegantly, thus expanding your toolbox.

Here are some tips to learn about new features:

* Always keep track of what you're working with at the moment (the data type). You'll almost always find the function you need in the corresponding section of the documentation, e.g. you have to study string functions to work with strings.
* Open the standard functions section of the topic you are studying every now and then and just run through them,, learning the signatures and ways to use them.
* Read other people's code more often, especially code from the libraries you're using. It's all available on GitHub.

Another feature of PHP functions from the Standard Library is that they're *available globally*. In other words, you can call them anywhere in your program (this doesn't work with functions you've written yourself). Most standard library functions are centered around some functionality or some type of data. For example, there's a large block of functions for processing strings, working with numbers, and so on. We'll go over some of them as you continue to study.
