В этом уроке разберем одну особенность некоторых функций. Они могут принимать переменное число параметров. Но речь идет не о значениях по умолчанию. Посмотрим на этот пример:

```php
<?php

max(1, 10, 3); // 10
max(1, -3, 2, 3, 2); // 3
```

Функция `max()` находит максимальное значение среди переданных параметров. Интересно, сколько параметров она ожидает на вход? Если открыть документацию этой функции, то мы увидим такую конструкцию:

```txt
max(mixed $value, mixed ...$values): mixed
```

Такая запись говорит о том, что эта функция принимает на вход два обязательных параметра и любое число необязательных. Необязательность передаваемых параметров описывается многоточием `...`.
