В программировании выражение – нечто возвращающее результат, который можно использовать. Напомним, что математические операции по типу сложения и вычитания и строковые операции — это выражения:

```php
<?php

1 + 5 * 3
'He' . 'Let'
// Переменные могут быть частью выражения
$rate * 5
```

Особенность выражений в том, что они возвращают результат, который можно, например, присвоить переменной или вывести на экран. Например:

```php
<?php

// Здесь выражение — это 1 + 5
$sum = 1 + 5;
print_r(1 + 5);
```

Выражения можно комбинировать и получать более сложное поведение в самых неожиданных местах и неожиданным образом. Об этом мы поговорим позже. В результате мы будем лучше понимать, как можно соединять части кода, чтобы получить нужный результат.

## Является ли функция выражением

Мы знаем, что функции возвращают результат, то есть они являются выражениями. Поэтому мы можем использовать вызов функции прямо в математических операциях.

Например, так можно получить индекс последнего символа в слове:

```php
<?php

$name = 'php';
// Индексы начинаются с нуля
// Вызов метода и вычитание вместе!
$last_index = strlen($name) - 1;
print_r($last_index); // 2
```

В этом коде нет нового синтаксиса. Мы только соединили уже известные части, опираясь на их природу. Можно пойти еще дальше:

```php
<?php

$name = 'php';
print_r(strlen($name) - 1); // => 2
```

Все это справедливо для любых функций, например, строковых:

```php
<?php

$name = 'Toto';
// Используется интерполяция
print_r("Имя пользователя: {$name}");
// => Имя пользователя: Toto
```
