
Рассмотрим функцию `round()`. Она округляет переданное число:

```php
<?php

$result = round(10.25, 0); // 10
```

Мы передали в неё два аргумента: число и точность округления. `0` означает, что округление будет до целого значения.

Чаще всего нужно округлять именно до целого числа (а не до десятых, например), поэтому создатели функции `round` сделали второй аргумент **необязательным** и задали ему внутри функции **значение по умолчанию `0`**. Значит, можно не указывать второй аргумент, а результат будет тем же:

```php
<?php

$result = round(10.25); // 10
```

А если нужна другая точность, то можно передать аргумент:

```php
<?php

$result = round(10.25, 1); // 10.3
```

Если функция в PHP принимает необязательные аргументы, то они всегда стоят после обязательных. Их количество может быть любым (это зависит от самой функции), но они всегда идут рядом и в конце списка аргументов.
