В этом уроке мы научимся работать с сигнатурой функции. Также мы узнаем, как функция принимает и возвращает значения. Мы разберем функции `abs()` и `round()`.

## Функция abs()

Функция `abs()`, которая возвращает абсолютное значение, принимает параметр — число. Если вызывать `abs()` без параметров, то PHP выдаст следующее:

```
TypeError: abs() expects exactly 1 argument, 0 given
```

Так интерпретатор сообщает, что функция ожидает один параметр, а мы вызвали ее без параметров.

Параметрами `abs()` могут быть только числа. Если мы попробуем передать в нее строку, это приведет к следующей ошибке:

```
TypeError: abs(): Argument #1 ($num) must be of type int|float, string given
```

Результат вызова этой функции — тоже всегда число. Другая функция может иметь иное число параметров и другие типы параметров. Например, может существовать функция, которая принимает три параметра: число, строку и еще одно число.

Откуда мы знаем, сколько и каких параметров нужно функции `abs()` и какого типа будет возврат? Мы посмотрели в **сигнатуру** этой функции. Сигнатура определяет входные параметры и их типы, а также выходной параметр и его тип.

О функции `abs()` можно почитать в [официальной документации PHP](https://www.php.net/manual/ru/function.abs.php). В разделе «Описание» есть такой текст:

```txt
abs(int|float $num): int|float

Возвращает абсолютное значение num.
```

Это сигнатура функции и короткое пояснение на русском языке.

Информация расшифровывается так:

* Функция называется `abs`
* Функция принимает параметр: число (num)
* Функция возвращает число
* Функция возвращает абсолютное значение num

Если параметров больше одного, то передавать их можно только в той последовательности, в которой они определены в сигнатуре. Любая функция возвращает всегда только одно значение. Это ограничение существует на уровне языка, и не может нарушаться.

## Аргументы по умолчанию

Рассмотрим функцию `round()`. Она округляет переданное число:

```php
<?php

$result = round(10.25, 0); // 10
```

Мы передали в нее два аргумента: число и точность округления. `0` означает, что округление будет до целого значения.

Чаще всего нужно округлять именно до целого числа, поэтому создатели функции `round` сделали второй аргумент необязательным и задали ему внутри функции значение по умолчанию `0`. Значит, можно не указывать второй аргумент, а результат будет тем же:

```php
<?php

$result = round(10.25); // 10
```

А если нужна другая точность, то можно передать аргумент:

```php
<?php

$result = round(10.25, 1); // 10.3
```

Если функция в PHP принимает необязательные аргументы, то они всегда стоят после обязательных. Их количество может быть любым. Это зависит от самой функции. Но такие аргументы всегда идут рядом и в конце списка аргументов.
