
The `pow()`, function, which raises a number to any power, takes two parameters: **which number to raise** and **to what power to raise it to**. If you call `pow()` without parameters, PHP outputs the following: `PHP Warning:  pow() expects exactly 2 parameters, 0 given in php shell code on line 1`. The interpreter has told you that the function expects 2 parameters, and that you called it without parameters.

Whoever created the `pow()`, function made it a function with two mandatory parameters, so it can't be called with any other number of parameters.

Moreover, the parameters of `pow()` can only be numbers. Attempting to pass, for example, a string to it will result in the following error: `PHP Warning:  A non-numeric value encountered in php shell code on line 1`. The result of this function call will also always be a number.

Other functions may have different numbers of parameters and different types of parameters. For example, there may be a function that takes three parameters: a number, a string, and another number.

How do we know how many parameters the `pow` function needs and what sort of result it'll return? We've taken a look at this function's **signature**. The signature defines the input parameters and their types, as well as the output parameter and its type. You can read about the `pow` function in [the official PHP documentation](https://www.php.net/manual/en/function.pow.php). In the "description" section, you can see this this text:

```
pow ( number $base , number $exp ) : number

Returns base raised to the power of exp.
```

This is a function signature and a short explanation.

The information is deciphered as follows:
- the function is called `pow`
- the function takes two parameters: a number (base) and a number (exp)
- the function returns a number (number)
- the function returns base raised to the power of exp

Parameters can only be passed in the order they're given in the signature.

Any function will always return only one value. This restriction exists at language level and cannot be broken.
