Сложение, конкатенация и остальные рассмотренные операции — это базовые возможности языков программирования. Но со строками можно поизводить более сложные операции. Их можно переворачивать, менять регистр букв, удалять лишние символы.

На более высоком уровне есть прикладная логика конкретного приложения. Программы списывают деньги, считают налоги, формируют отчеты. Количество подобных операций бесконечно и индивидуально для каждой программы. И все они должны быть выражены в коде. В этом помогают функции, с которыми мы познакомимся в этом уроке.

## Какие бывают функции

Для выражения любой произвольной операции в программировании существуют **функции**. Они бывают встроенными и добавленными программистом. С одной встроенной функцией мы уже знакомы — это `print_r()`.

**Функции** — одна из ключевых конструкций в программировании, без них невозможно сделать практически ничего. Сначала мы научимся пользоваться уже созданными функциями, а потом научимся создавать свои.

## Как работать со встроенными функциями

Начнем с простых функций для работы над строками. Ниже пример вызова функции `strrev()`, которая переворачивает строку:

```php
<?php

// Вызов функции strrev с аргументом 'Hello!'
$result = strrev('Hello!');
print_r($result); // => '!olleH'
```

Мы создали переменную `$result` и указали интерпретатору записать в нее результат, который вернет вызов функции `strrev()`. В этом смысле функции идентичны операциям — они всегда возвращают результат своей работы.

Запись `strrev('Hello!')` означает, что вызывается функция с именем `strrev`, в которую был передан аргумент или параметр `'Hello!'`.

Аргументы нужны функциям для работы так же, как операторам нужны операнды. Функция `strrev()` переворачивает ту строку, которая передается ей в аргументах.

Вызов функции всегда обозначается скобками `()`. Они идут сразу за именем функции. В скобках может быть любое количество аргументов, а иногда — ни одного. Количество зависит от используемой функции. Например, функция `pow()` принимает на вход два аргумента и возводит число, переданное первым параметром, в степень, переданную вторым параметром:

```php
<?php

$result = pow(2, 3); // 2 * 2 * 2
print_r($result); // => 8

// В современном PHP появился специальный оператор для возведения в степень
$result = 2 ** 3; // 8
```

Теперь рассмотрим пример функции, которая не принимает аргументов. Функция `rand()` генерирует и возвращает случайное число:

```php
<?php

$result = rand();
```

Операторы и функции — это одно и то же. Разница в том, как они записываются. Если представить сложение как функцию, то она будет выглядеть так:

```php
<?php

3 + 5; // 8
sum(3, 5); // 8

// Или даже так
+(3, 5);

// В PHP такой синтаксис невозможен, но есть языки (например, lisp),
// где оно выглядит очень похоже
```

Вопрос на самопроверку. Как узнать, что возвращает вызов `print_r()`? Проверьте.
