Определять строки в PHP можно с помощью специального heredoc-синтаксиса. После оператора `<<<` необходимо указать идентификатор с произвольным именем, затем перевод строки и саму строку. В конце добавляется тот же идентификатор, который закрывает вставку. Такой способ удобен для задания длинных строк, внутри которых встречаются и переводы строк, и разнотипные кавычки:

```php
<?php

$str = <<<EOT
Пример строки,
охватывающей несколько строк,
с использованием heredoc-синтаксиса.
Здесь не нужно экранировать ни одинарные ', ни двойные " кавычки.
EOT;
print_r($str);
// => Пример строки,
// => охватывающей несколько строк,
// => с использованием heredoc-синтаксиса.
// => Здесь не нужно экранировать ни одинарные ', ни двойные " кавычки.
```

Перед закрывающим идентификатором, в нашем случае — `EOT`, не должны стоять пробелы, иначе PHP начнет ругаться на ошибку синтаксиса.
