В этом уроке мы научимся получать из строки конкретный символ. Например, если сайт знает имя и фамилию пользователя, и в какой-то момент требуется вывести эту информацию в формате `A. Ivanov`. В этом случае нужно взять первый символ из имени:

```php
<?php

$firstName = 'Alexander';

print_r($firstName[0]); // => A
```

Квадратные скобки с цифрой — это специальный оператор извлечения строки. Эта цифра называется **индексом** — позицией символа внутри строки.

Индексы начинаются с нуля почти во всех языках программирования. Чтобы получить первый символ, нужно указать индекс `0`. Индекс последнего элемента равен длине строки минус единица:

```php
<?php

$firstName = 'Alexander';

// Длина строки 9, поэтому последний индекс — это 8
print_r($firstName[8]);  // => r

// Вопрос на самопроверку. Что выведет этот код?
$magic = '\nyou';
print_r($magic[1]); // => ?
```

Также допустимо использовать отрицательные индексы. В этом случае идет обращение к символам с конца строки. `-1` — индекс последнего символа, `-2` — предпоследнего и так далее. В отличие от прямой индексации обратный отсчет идет от `-1`:

```php
<?php

$firstName = 'Alexander';

print_r($firstName[-1]); // => r
```

Индексом может быть не только конкретное число, но и значение переменной. Вот пример, который приведет к тому же результату — выводу на экран символа `A`:

```php
<?php

$firstName = 'Alexander';
$index = 0;

print_r($firstName[$index]); // => A
```

Здесь индекс внутри квадратных скобок записан не числом, а переменной.
