Представим, что нам нужно создать заголовок письма из двух переменных и знаков препинания. Эту задачу можно решить так:

```php
<?php

$firstName = 'Joffrey';
$greeting = 'Hello';

print_r($greeting . ", " . $firstName . "!"); // => 'Hello, Joffrey!'
```

Это простой случай, но даже здесь нужно приложить усилия, чтобы увидеть, какая в итоге получится строка. Нужно следить за несколькими кавычками и пробелами, и с первого взгляда сложно понять, что и где начинается и заканчивается.

Есть другой более удобный способ — **интерполяция**. Так это выглядит:

```php
$firstName = 'Joffrey';
$greeting = 'Hello';

// Обратите внимание на ограничители строки — это двойные кавычки
// Интерполяция не работает с одинарными кавычками
print_r("{$greeting}, {$firstName}!"); // => Hello, Joffrey!
```

https://replit.com/@hexlet/php-basics-interpolation

В этом примере мы создали одну строку и в нужном нам порядке вставили в нее переменные с помощью фигурных скобок (`{}`). Получился шаблон, куда внесены нужные значения.

Теперь нам не нужно заботиться об отдельных строках для знаков препинания и пробелов. Эти символы записаны в строке-шаблоне.

В одной строке можно делать сколько угодно блоков с фигурными скобками. Также интерполяция работает только со строками в двойных кавычках.

Почти во всех языках интерполяция предпочтительнее конкатенации для объединения строк. Строка при этом получается склеенная, и внутри нее хорошо просматриваются пробелы и другие символы.
