Разработчики часто работают с данными, которые никогда не меняются. Например, число π, которое всегда равно `3.14` и не может измениться.

Для обращения к подобным данным в PHP принято использовать константы:

```php
<?php

const PI = 3.14;
print_r(PI); // => 3.14
```

Создание константы отличается от создания переменной. Оно начинается с ключевого слова `const` и последующего имени константы. При этом знак доллара не нужен. Далее ей присваивается нужное значение.

Константы принято именовать буквами в верхнем регистре с `_` в качестве разделителя. Константа тоже может использоваться в любом выражении. Единственное ограничение — константу нельзя изменить.

В PHP много встроенных констант, которые можно использовать в любом месте программы. Вот некоторые из них:

* `PHP_VERSION` — текущая версия PHP
* `PHP_MAXPATHLEN` — максимальная разрешенная длина имени файла
* `PHP_INT_MAX` — максимальное возможное значение целых чисел (integer)

Кроме обычных констант в PHP существует отдельная группа — **магические константы**. Их отличия заключаются в следующем:

* Магические константы невозможно определить самому, можно пользоваться только существующими
* Магические константы начинаются и заканчиваются символами `__` (два подчеркивания)
* Магия заключается в том, что такие константы имеют одно и то же значение только в пределах определенной части программы

Последний пункт говорит о том, что существуют не очень постоянные константы, но их изменения регламентированы и на практике не вызывают проблем. К подобным константам относятся:

* `__LINE__` — содержит текущую строку файла, в котором она используется
* `__FILE__` — путь до текущего файла
* `__DIR__` — путь до директории, в которой находится текущий файл
