Некоторые имена довольно просты — например, `$greeting`. Но часто все не так очевидно. Довольно часто имена составные, то есть включают в себя несколько слов. Например, «имя пользователя». В разных языках применяются разные стили кодирования, и имя переменной будет отличаться.

В именовании переменных можно выделить четыре основных подхода, которые иногда комбинируют друг с другом. Все эти подходы проявляют себя, когда имя переменной состоит из нескольких слов:

* kebab-case — составные части переменной разделяются дефисом (`my-super-var`)
* snake_case — для разделения используется подчеркивание (`my_super_var`)
* CamelCase  — каждое слово в переменной пишется с заглавной буквы (`MySuperVar`)
* lowerCamelCase — каждое слово в переменной пишется с заглавной буквы, кроме первого (`mySuperVar`)

В PHP используется CamelCase и его вариация lowerCamelCase, при котором первая буква первого слова — строчная. Именно lowerCamelCase применяется для переменных. Это значит, что имена соединяются друг с другом, при этом все имена кроме первого становятся с заглавной буквы: `$userName`. С тремя словами это выглядит так: `$mySuperVariable`.

Другое общепринятое правило гласит — не используйте транслит для имен, только английский язык. Если вы испытываете сложности с английским, то пользуйтесь переводчиком. Со временем, копаясь в чужом коде, вы сформируете правильные представления об именовании.

Названия должны не только передавать смысл, но и соответствовать синтаксическим правилам, которые обычно никак не проверяются на уровне языка, но нужны во время разработки. Процесс написания программ в современном мире — коллективная работа, и для лучшего взаимодействия в команде код пишется в едином стиле, как если бы над ним работал один человек.

В каждом языке свои правила. Относительно недавно в PHP появился общепринятый [стандарт кодирования](https://www.php-fig.org/psr/psr-1/), к которому все так или иначе стремятся. Подобные стандарты описывают множество аспектов. Советуем с самого начала завести привычку заглядывать в стандарт и писать код в соответствие с ним.

К счастью, сегодня не нужно помнить все правила из стандарта, потому что существуют специальные программы, которые проверяют код автоматически и сообщают о нарушениях. Такие программы называются **линтерами**, и вы начнете их использовать немного позже, когда у вас появится чуть больше опыта.
