
`$greeting` is an example of a simple name, but not all names are that simple. Often, they're a combination of several words. For example, "user password". Different languages have different naming styles for variables.

There are three main variable naming conventions, which are sometimes combined. These conventions apply to variable names consisting of several words:

* kebab-case — a hyphen separates the parts of the name.  For example, `my-super-var`.
* snake_case — an underscore is used as a separator.  For example, `my_super_var`.
* CamelCase  — each word in the name is capitalized. For example, `MySuperVar`.
* lowerCamelCase — each word is capitalized except the first. For example, `mySuperVar`.

PHP uses CamelCase and its variation lowerCamelCase, where the first letter of the first word is lowercase. We use lowerCamelCase for variables. This means that names are joined together, with all but the first word capitalized: `$userName`. With three words, it looks like this: `$mySuperVariable`.

Over time, by digging through other people's code, you'll develop the right concepts for naming.

Names should not only convey meaning, but also correspond to syntactic rules, which aren't usually checked by the language, but are still needed during development. Program writing in today's world is a team effort, and for better teamwork, code should be written in a unified style. Every language has its own rules. PHP has been in chaos for a long time. And the language itself is riddled with contradictions, and not only with names. You will encounter this in the following lessons and in real work. A [coding standard](https://www.php-fig.org/psr/psr-1/), for PHP only appeared relatively recently, and everyone is striving to meet it one way or another. Standards describe multiple aspects. We recommend making a habit of looking at the standard and writing code according to it from the very beginning.

Fortunately, nowadays, you don't need to remember all the rules from the standard, because there are special programs that check the code automatically and report violations. These programs are called **linters**, and you'll start using them later when you have a little more experience.
