Переменные полезны не только для хранения и переиспользования информации. Также они нужны, чтобы упрощать сложные вычисления. В этом уроке мы научимся делать это.

## Используем выражение

Допустим, нам нужно перевести евро в юани через доллары. Подобные конвертации через промежуточную валюту часто делают банки при покупках за рубежом.

Для начала переведем 50 евро в доллары. Допустим, один евро равен 1.25 доллара:

```php
<?php

$dollarsCount = 50 * 1.25;
print_r($dollarsCount);
```

Ранее мы записывали в переменную конкретное значение. А здесь в `$dollarsCount = 50 * 1.25;` справа от знака равно находится **выражение**. Интерпретатор вычислит результат — `62.5` — и запишет его в переменную.

Для интерпретатора неважно, что перед ним: `62.5` или `50 * 1.25`. Для него оба варианта — выражения, которые надо вычислить. И они вычисляются в одно и то же значение — `62.5`.

Любая строка — это выражение. Конкатенация строк — тоже выражение. Когда интерпретатор видит выражение, он обрабатывает его и генерирует результат — **значение выражения**.

Вот несколько примеров выражений, а в комментариях справа от каждого выражения — итоговое значение:

```php
<?php

62.5             // 62.5
50 * 1.25        // 62.5
120 / 10 * 2     // 24
(int) '100'      // 100

"hello"          // "hello"
"Good" . "will"  // "Goodwill"
```

Теперь запишем стоимость доллара в юанях как отдельную переменную. Вычислим цену 50 евро в долларах, умножив их на `1.25`. Допустим, что 1 доллар — 6.91 юаней:

```php
<?php

$yuansPerDollar = 6.91;
$dollarsCount = 50 * 1.25; // 62.5
$yuansCount = $dollarsCount * $yuansPerDollar; // 431.875

print_r($yuansCount);
```

Любая переменная может быть частью любого выражения. В момент вычисления вместо имени переменной подставляется ее значение. Интерпретатор вычисляет значение `$dollarsCount` до того, как эта переменная начнет использоваться в других выражениях. Когда подходит момент использования переменной, PHP знает значение, потому что уже вычислил его.

## Используем переменные с конкатенацией

Использовать переменные можно и с конкатенацией. Синтаксически ничего не меняется: мы умеем конкатенировать (склеивать) две строки:

```php
<?php

$what = "Kings" . "road";
print_r($what); // => "Kingsroad"

// Конкатенируем строку и переменную, в которой записана строка
$first = "Kings";
$what = $first . "road";
print_r($what); // => "Kingsroad"

// Конкатенируем две переменные, в которых записаны строки
$last = 'road';
$what = $first . $last;
print_r($what); // => "Kingsroad"
```
