Переменную нужно объявить до ее использования. Если сделать это позже, то программа не заработает:

```php
<?php

print_r($greeting);
$greeting = 'Father!';
// PHP Notice:  Undefined variable: greeting in /private/var/tmp/index.php on line 3
```

Запуск программы выше завершается с ошибкой `PHP Notice`_ — это ошибка обращения. Она означает, что в коде используется имя (идентификатор), которое не определено. При этом в самой ошибке указан идентификатор переменой: `greeting`.

Также к ошибке могут привести опечатки при использовании переменной и во время ее объявления. Количество подобных ошибок уменьшается за счет использования правильно настроенного редактора. Такой редактор подсвечивает имена, которые используются без объявления, и предупреждает о возможных проблемах.
