En esta lección hablaremos sobre la nomenclatura. Comenzaremos estudiando un ejemplo. Veamos el siguiente programa:

```php
<?php

$x = '¡Padre!';
print_r($x);
print_r($x);
```

Funciona, pero tiene un nombre de variable extraño: `$x`. A los ordenadores no les importa cómo llamamos a las variables, pero a los programadores sí. Escribimos código mucho menos de lo que lo leemos. Además, a menudo tenemos que leer código escrito por otras personas. La calidad y la comprensibilidad de los nombres de las variables son fundamentales para el éxito en el análisis del código.

Es mejor tomarse el tiempo para pensar en un nombre que describa bien la esencia de la variable, en lugar de nombrarla al azar y tener que cambiarla en el futuro. Intente darles nombres que sean lo más comprensibles posible sin contexto y sin estudiar el código circundante.

Entre los desarrolladores hay un chiste: "lo más difícil de la programación son los nombres de las variables y la invalidación de la caché". De hecho, es difícil inventar nombres. Por ejemplo, ¿qué nombre elegiría para una variable que almacena la cantidad de pedidos impagados de clientes con deudas del trimestre anterior?

Para sumergirse más en el tema, intente hacer una tarea adicional: invente un nombre para una variable que almacene "la cantidad de hermanos y hermanas del rey". Escríbalo en un bloc de notas o envíeselo por correo electrónico. No incluya nada más que el nombre de la variable. Volveremos a este tema en unas lecciones.
