Со временем внутри программы значения переменных могут изменяться:

```php
<?php

// greeting - переводится как приветствие
$greeting = 'Father!';
print_r($greeting); // => Father!

$greeting = 'Mother!';
print_r($greeting); // => Mother!
```

Имя осталось тем же, но внутри другие данные. Переменные в PHP не требуют специального объявления. Вместо этого переменная объявляется при первом ее использовании в программе.

Никогда нельзя быть точно уверенным, что записано внутри переменной. Чтобы быть спокойным, нужно проанализировать код, который находится перед переменной. Этим занимаются разработчики во время отладки, когда пытаются разобраться, почему программа не работает или работает не так, как задумано.

Переменные меняются нечасто. Обычно их используют, чтобы хранить.
