
Imagine we need to type the phrase _Father!_ twice or even five times on the screen. You can solve it via brute force:

```php
<?php

print_r('Father!');
print_r('Father!');
```

In the simplest case, this is what you should do, but if the phrase _Father!_ starts to be used more and more often, and in different parts of the program, you'll have to repeat it everywhere. Then you'll face even more issues when it turns out that you need to change the phrase. This is a common scenario in development. We have to find all the places where the phrase _Father!_ was used and make the necessary substitutions. There is one other way to do it. Instead of copying our expression, just create a variable containing this phrase.

```php
<?php

// greeting 
$greeting = 'Father!';
print_r($greeting);
print_r("\n");
print_r($greeting);
```

The line `$greeting = 'Father!'` assigns the value `'Father!'` to a variable named `$greeting`. In PHP, variable names begin with a *$* sign. As a result, the variable points to the data that was written to it.

Once the variable's been created, you can start using it. You put it in the places where we originally had our phrase written out in full. At runtime, the interpreter (the program that executes the PHP code), reaches the line `print_r($greeting);` and replaces the variable with its contents, and then executes the code. As a result, the output of our program will be as follows:

<pre class='hexlet-basics-output'>
  Father!
  Father!
</pre>

Any set of valid characters can be used for a variable name, which includes letters of the English alphabet, numbers, and the `_`. Note that you can't place a digit at the beginning of a name. Variable names are case-sensitive, which means that `hello` and `heLLo` are two different names and thus two distinct variables. Case is important in PHP, never forget it.

The number of variables you can create isn't limited in any way, large programs contain tens and hundreds of thousands of variable names:

```php
<?php

$greeting1 = 'Father!';
print_r($greeting1);
print_r($greeting1);

$greeting2 = 'Mother!';
print_r($greeting2);
print_r($greeting2);
```

For the convenience of program analysis, it's customary to create variables as close as possible to where they're used.
