
Type conversion is a fairly common operation in web development. On the one hand, you can rely on weak typing to perform it, on the other hand, in many situations it's better to do the conversion explicitly, using special syntax. This code is clearer and more predictable.

```php
<?php

// These examples are a bit artificial. In reality, this mechanism is much more useful when using variables
print_r((string) 5);
print_r((int) '345');
```

Explicit type conversion works like this: the desired type is specified before the value, in parentheses. As a result, the value on the right is converted to a value of the other type specified on the left in brackets. We're currently only familiar with two types, but the conversion works for any type. For example, when converting a fractional number to a whole number, the number will be rounded down

```php
<?php

print_r((int) 5.73); // => 5
```

Type conversion can be used within compound expressions:

```php
<?php

// Additional brackets help to visually separate parts of an expression from each other
print_r('This is ' . ((string) 5));
```

<pre class='hexlet-basics-output'>
  Это 5
</pre>

In more complex situations (when using functions that are passed later) multiple conversions are encountered: `(string) (5 + ((int) '4'))`. The procedure for calculating this expression is as follows:

```php
<?php

(int) '4';  // 4
5 + 4;      // 9
(string) 9; // '9'
```
