## Какие бывают типы данных

Существуют разные способы представлять данные в программах:

* **Строки** — наборы символов в кавычках, вроде `"Hello, World!"`
* **Целые числа** — например, `7`, `-198`, `0`

Это две разные категории информации — два разных **типа данных**.

Операция умножения имеет смысл для целых чисел, но не имеет смысла для строк. Умножать слово «мама» на слово «блокнот» — бессмыслица. Тип данных определяет, что можно делать с элементами конкретного множества элементов.

Язык программирования распознает типы. Поэтому PHP не позволит нам умножать текст на текст. Но позволит умножать целое число на другое целое число. Наличие типов и таких ограничений в языке защищает программы от случайных ошибок.

В отличие от строк, числа оборачивать в кавычки не нужно. Чтобы напечатать число 5, достаточно написать:

```php
<?php

print_r(5);
```

Число `5` и строка `'5'` — разные вещи, хотя вывод у `print_r()` для этих данных идентичный.

Целые числа, например, `1`, `34`, `-19`, и рациональные числа, например, `1.3`, `1.0`, `-14.324`, — это два отдельных типа данных. Такое разделение связано с особенностями устройства компьютеров. Есть и другие типы, с ними мы познакомимся позже.

Пример с рациональным числом:

```php
<?php

print_r(10.234);
```

Типы данных «строка», «целое число» и «рациональное число» — это примитивные типы. Они встроены в сам язык PHP.

В язык также встроены и некоторые составные типы данных, но пока мы будем работать только с примитивными. Программисты также могут создавать собственные типы данных.

По-английски строки в программировании называются **strings**, а строчки текстовых файлов — **lines**. Например, в коде выше есть три lines, и нет strings.

В русском языке может быть путаница, поэтому во всех уроках мы будем говорить «строка» для обозначения типа данных «строка», и «строчка» — для lines в файлах.
