В веб-разработке программы постоянно оперируют строками. Все, что мы видим на сайтах, так или иначе представлено в виде текста. Этот текст чаще всего динамический — полученный из разных частей, которые соединяются вместе. Операция соединения строк в программировании называется **конкатенацией**.

Мы уже знаем о математической операции сложения:

```php
<?php

print_r(5 + 3); // => 8
```

Такая программа выведет на экран `8` — результат работы бинарного оператора `+` с операндами `5` и `3`.

Можно также «сложить» две строки. Такая программа выведет на экран `Dragonstone` — результат работы бинарного оператора `.` с операндами 'Dragon' и 'stone':

```php
<?php

print_r('Dragon' . 'stone'); // => Dragonstone
```

https://replit.com/@hexlet/php-basics-strings-concatenation

Склеивание строк всегда происходит в том же порядке, в котором записаны операнды. Левый операнд становится левой частью строки, а правый — правой. Вот еще несколько примеров:

```php
<?php

print_r('Kings' . 'wood');     // => Kingswood
print_r('Kings' . 'road');     // => Kingsroad
print_r("King's" . 'Landing'); // => King'sLanding
```

Строки можно склеивать, даже если они записаны с разными кавычками.

Пробел — такой же символ, как и другие, поэтому сколько пробелов поставить в строке — столько и получится в итоговой строке:

```php
<?php

// Ставим пробел в левой части
print_r("King's " . 'Landing'); // => King's Landing

// Ставим пробел в правой части
print_r("King's" . ' Landing'); // => King's Landing
```
