Иногда нам необходимо расположить несколько строк друг за другом. Для этого нужно сказать интерпретатору «нажать на энтер» — сделать перевод строки после вопросительного знака. Это можно сделать с помощью символа перевода строки — `\n`:

```php
<?php

print_r("- Are you hungry?\n- Aaaarrrgh!");
```

https://replit.com/@hexlet/php-basics-strings-newline

Результат:

```php
- Are you hungry?
- Aaaarrrgh!
```

`\n` — это специальный символ. В литературе его часто обозначают как *LF* (Line Feed). С точки зрения компьютера — это один невидимый символ перевода строки:

```php
<?php

// Мы это не изучали, но вы должны знать правду
// Ниже код, который возвращает длину строки
strlen("a");    // 1
strlen("\n");   // 1 !!!
strlen("\n\n"); // 2 !!!
```

`\n` — это способ записать символ перевода строки, но сам перевод строки — это один невидимый символ. Так как количество знаков на клавиатуре ограничено и отдано под самые важные, то все специальные символы реализуются в виде таких обозначений.

Символ перевода строки не является специфичным для программирования. Во многих редакторах есть опция, которая позволяет включить отображение невидимых символов. С ее помощью можно понять, где они находятся. Хотя это всего лишь схематичное отображение, у этих символов нет графического представления, они невидимые.

`\n` — это пример **экранирующей последовательности** (escape sequence). Их еще называют управляющими конструкциями. Таких символов не один десяток, но в программировании часто встречаются всего несколько. Программистам часто нужно использовать перевод строки `\n` для правильного форматирования текста.

Экранирующие последовательности вроде `\n` работают только внутри двойных кавычек.

Если нам понадобится вывести `\n` именно как текст, то можно воспользоваться уже известным нам способом экранирования — добавить еще один `\` в начале. В итоге последовательность `\\n` отобразится как символы `\` и `n`, которые идут друг за другом.

В Windows для перевода строк по умолчанию используется `\r\n`. Такая комбинация хорошо работает только в Windows, но создает проблемы при переносе в другие системы. Например, когда в команде разработчиков есть пользователи как Windows, так и Linux.

Последовательность `\r\n` имеет разную трактовку в зависимости от выбранной кодировки. Это мы рассмотрим позже. По этой причине в среде разработчиков принято всегда использовать `\n` без `\r`, так как LF всегда трактуется одинаково и отлично работает в любой системе. Поэтому нужно настроить свой редактор на использование `\n`.
