В этом уроке мы разберем, что такое строки, зачем для них нужны одинарные и двойные кавычки. Также узнаем, что такое экранирующие последовательности и конкатенация.

## Что такое строка

Любой одиночный символ в кавычках — это **строка**. Например:

```php
'Hello'
'Goodbye'
'G'
' '
''
```

Пустая строка `''` — это тоже строка. То есть строкой мы считаем все, что находится внутри кавычек, даже если это пробел, один символ или вообще отсутствие символов.

Ранее в уроках мы записывали строки в одинарных кавычках, но можно использовать и двойные:

```php
<?php

print_r("Dracarys!");
```

Разберем, почему у обозначения строки есть два способа.

## Зачем нужны двойные кавычки

Представим, что нам нужно напечатать строчку ``dragon's mother``. Апостроф перед буквой **s** — это такой же символ, как одинарная кавычка. Попробуем:

```php
<?php

print_r('Dragon's mother');
// PHP Parse error: syntax error, unexpected 's' (T_STRING), expecting ',' or ')'
```

Такая программа не будет работать. С точки зрения PHP строчка началась с одинарной кавычки, а потом закончилась после буквы **n**. Дальше были символы `s mother` без кавычек — значит, это не строка. А потом была одна открывающая строку кавычка, которая так и не закрылась: `');`. Этот код синтаксически некорректен.

Здесь помогут двойные кавычки. Такой вариант программы отработает корректно:

```php
<?php

print_r("Dragon's mother");
```

Теперь интерпретатор знает, что строка началась с двойной кавычки, значит, завершиться должна на двойной кавычке. А одинарная кавычка внутри стала частью строки.

Верно и обратное. Если внутри строки мы хотим использовать двойные кавычки, то саму строку надо делать в одинарных. Причем количество кавычек внутри самой строки неважно.

Теперь представим, что мы хотим создать такую строку:

```php
Dragon's mother said "No"
```

В ней есть и одинарные, и двойные кавычки. В этой ситуации нужно указать интерпретатору, что нужно считать каждую кавычку частью строки, а не началом или концом.

Для этого **экранируют** специальные символы. В нашем случае это символ, который является признаком конца и начала строки, — либо одинарная кавычка, либо двойная, в зависимости от ситуации. Для экранирования используется обратный слеш `\`.

```php
<?php

// Экранируется только ", так как в этой ситуации
// двойные кавычки имеют специальное значение
print_r("Dragon's mother said \"No\"");
// => Dragon's mother said "No"
```

Нам нужно было добавить `\` для двойных кавычек, но не для апострофа, потому что сама строка создана с двойными кавычками. Если бы строка создавалась с одинарными кавычками, то символ экранирования нужен был бы перед апострофом, но не перед двойными кавычками.

```php
<?php

// \ выводится, если после него идет обычный,
// а не специальный символ
print_r("Death is \so terribly final");
// => Death is \so terribly final
```

Также нам может понадобиться вывести сам обратный слеш:

```php
<?php

print_r("\\");
// => \
```

Это тоже можно сделать через экранирование, но уже самого себя.
