В этом уроке мы узнаем, что такое стандарты по написанию кода. Они облегчают разработку и делают код более понятным. Мы подробнее разберем две основные рекомендации по PHP, которые содержат правила по написанию кода.

## Стандарты по написанию кода в PHP

Код нужно оформлять так, чтобы он был понятным и простым в поддержке. Для этого существуют специальные наборы правил — **стандарты**. Они описывают различные аспекты написания кода.

В PHP самыми распространенными являются стандарты **PSR** — PHP Standards Recommendations или стандартные рекомендации PHP от [PHP-FIG](https://www.php-fig.org/psr/). Это набор правил, которые облегчают разработку и решают определенную проблему.

На текущий момент существует несколько утвержденных рекомендаций, каждая из них обозначена цифрой: PSR-1, PSR-2, PSR-3 и [другие](https://en.wikipedia.org/wiki/PHP_Standard_Recommendation). Со всеми рекомендациями вы познакомитесь во время обучения и работы.
В этом уроке разберем подробнее следующие:

* PSR-1. [Basic Coding Standard](https://www.php-fig.org/psr/psr-1/) — базовый стандарт написания кода. Это набор правил, которые определяют, как следует оформлять программный код: как писать теги PHP, по каким правилам именовать классы, методы и константы классов. Он также затрагивает вопросы кодировки, автозагрузки, пространства имен и разделения ответственности между файлами
* PSR-12. [Extended Coding Style](https://www.php-fig.org/psr/psr-12/) — расширенный стандарт стиля кодирования, заменяет и дополняет устаревший PSR-2. Этот стандарт требует выполнения правил PSR-1. Также он добавляет множество новых требований: к отступам, файлам, строкам, ключевым словам, классам, управляющим конструкциям, области видимости и другим элементам

## Линтеры в PHP

В любом языке программирования существуют специальные инструменты — **линтеры**. Они проверяют код на соответствие стандартам. Повсеместно используемым линтером в PHP является [PHP_CodeSniffer](https://github.com/squizlabs/PHP_CodeSniffer).

Допустим, у нас есть файл с таким PHP-кодом:

```php
<?php

// На следующей строке отступ равен одному табу
	print_r (((8 / 2) + 5) - (-3 / 2));

?>
```

При проверке файла линтер найдет следующие ошибки:

* `Spaces must be used to indent lines; tabs are not allowed` — PSR-12 рекомендует делать отступ размером в четыре пробела, а в примере выше использована табуляция
* `A closing tag is not permitted at the end of a PHP file` — стандарт содержит требование опускать завершающий тег `?>`
* `Space before opening parenthesis of function call prohibited` — при вызове функции между именем функции и круглыми скобками не должно быть пробельных символов, а в проверяемом коде после имени `print_r` стоит один пробел

Исправим код — уберем закрывающий тег, отступы и пробел после имени функции:

```php
<?php

print_r(((8 / 2) + 5) - (-3 / 2)); // => 10.5
```

Этот вариант уже не нарушает правил, и линтер будет «молчать».
