В школьной математике есть понятие «приоритет операции». Приоритет определяет, в какой последовательности должны выполняться операции.

Допустим, нам нужно вычислить такое выражение: `2 + 2 * 2`:

```php
<?php

print_r(2 + 2 * 2); // => 6
```

Интерпретатор производит арифметические вычисления в правильном порядке: сначала деление и умножение, потом сложение и вычитание, а приоритет возведения в степень выше всех остальных арифметических операций: `2 ** 3 * 2` вычислится в `16`.

Иногда вычисления должны происходить в другом порядке. В этом случае приоритет задают круглыми скобками, например: `(2 + 2) * 2`. Скобки можно ставить вокруг любой операции. Они могут вкладываться друг в друга сколько угодно раз. Вот пара примеров:

```php
<?php

print_r(3 ** (4 - 2)); // => 9
print_r(7 * 3 + (4 / 2) - (8 + (2 - 1))); // => 14
```

В этом случае главное закрывать скобки в правильном порядке. Это часто становится причиной ошибок не только у новичков, но и у опытных программистов. Для удобства можно сразу ставить открывающую и закрывающую скобки, а потом писать внутреннюю часть.

Сейчас большинство редакторов кода делают это автоматически. Например, мы ставим открывающую скобку, а он автоматически ставит закрывающую. Это касается и других парных символов, например, кавычек. О них — в будущих уроках.

Иногда выражение сложно воспринимать визуально. Тогда можно расставить скобки, не повлияв на приоритет. Код пишется для людей, а машины будут только исполнять его. Для машин код — или корректный, или не корректный. Для них нет «более» понятного или «менее» понятного кода. Явная расстановка приоритетов упрощает чтение кода другими разработчиками.
