Look closely at the expression `2 + 2 * 2` and try and work out the answer.

The correct answer is `6`.

If you got `8`, then this lesson is for you. You'll have studied the order of operations in high school math. This concept defines the order in which operations are to be performed. For example, multiplication and division have a higher precedence than addition and subtraction, and exponentiation comes before all other arithmetic operations, e.g., `2 ** 3 * 2` gives us `16`.

But sometimes, we have to perform calculations in a non-standard order. In complex cases, precedence can (and must) be set with parentheses, just like we did in high school, e.g, `(2 + 2) * 2`.

Parentheses fit with any operation. They can be nested into each other as many times as you need. Here are a couple of examples:

  ```php
  <?php

 print_r(3 ** (4 - 2)); // => 9
 print_r(7 * 3 + (4 / 2) - (8 + (2 - 1))); // => 14
  ```

The main thing is to make sure to close the parentheses in the correct order. This often causes errors not just for beginners but also for experienced programmers. For convenience's sake, do the opening and closing parentheses first, and then write the inside part. The editor on our site (and most other code editors) does this automatically: you write `(`, and the editor immediately adds `)`. This also applies to other paired characters, such as quotation marks. We'll talk about them in future lessons.

Sometimes, an expression can be visually cumbersome. In such cases, parentheses can come in handy without affecting the order of operations. For example, the task from the previous lesson gets clearer if you have parentheses.

Before:

```php
<?php

print_r(8 / 2 + 5 - -3 / 2); // => 10.5
```

After:

```php
<?php

print_r(((8 / 2) + 5) - (-3 / 2)); // => 10.5
```

Note: code is written for humans, since they'll be the ones to read it, the machine just executes it. For the machine, code is either valid or invalid, it doesn't recognize "more" or "less" valid code. Explicit prioritization makes it easier for other developers to read your code.
