Знак операции, например, `+`, называют **оператором**. Операторы обычно представлены одним или несколькими символами, реже — словом. Обычно они соответствуют математическим операциям.

Операторы выполняют операции над определенными значениями, которые называются **операндами**.

Рассмотрим пример:

```php
<?php

print_r(8 + 2);
```

Здесь `+` — это оператор, а числа `8` и `2` — это операнды.

Операции, которые требуют наличия двух операндов, называются **бинарными**. В случае сложения у нас есть два операнда: один слева от знака `+`, другой — справа. Если пропустить хотя бы один операнд, например, `3 + ;`, то программа завершится с синтаксической ошибкой.

Еще операции бывают **унарными** — с одним операндом, и тернарными — с тремя операндами. Причем операторы могут выглядеть одинаково, но обозначать разные операции.

Символы `+` и `-` используются не только как операторы. Когда речь идет про отрицательные числа, то знак минуса становится частью числа:

```php
<?php

print_r(-3); // => -3
```

Выше пример применения унарной операции к числу `3`. Оператор `-` перед тройкой говорит интерпретатору взять число `3` и найти противоположное, то есть `-3`. Это может сбить с толку, потому что `-3` — это одновременно и число, и оператор с операндом. Но у языков программирования такая структура:

```php
<?php

// То же самое, что и 4 - 3
print_r(4 + -3); // => 1
```

То же самое касается и плюса:

```php
<?php

print_r(+3); // => 3
print_r(1 + +3); // => 4
```
