
Before we move on, let's take a look at the basic terminology. An operation sign, such as `+`, is called an **operator**. Operators perform operations on certain values, which are called **operands**. The operators themselves are usually represented by one or more characters,, and occasionally by a word. Most of the operators are identical to those you'll have seen in math class.

```php
<?php

print_r(8 + 2);
```

In this example `+` is an **operator**, and the numbers `8` and `2` are **operands**.

When it comes to addition, we have two operands: one to the left of the `+` sign and one to the right. Operations with two operands are called **binary** operations. If at least one operand is omitted, e.g., `3 + ;`, the program will end with a syntax error.

Operations can be more than just binary, they can also be unary (one operand), and even ternary (three operands). Moreover, operators may look the same but denote different operations. The symbols `+` and `-` are used as more than just operators. When it comes to negative numbers, the minus sign becomes part of the number:

```php
<?php

print_r(-3); // => -3
```

Above is an example of applying a unary operation to the number `3`. The minus operator before the three tells the interpreter to take the number `3` and find the opposite, which is `-3`.

This can be a bit confusing because `-3` is both a number in itself and an operator with an operand, but this is just how programming languages are structured.

```php
<?php

// Same as 4 - 3
print_r(4 + -3); // => 1
```

The same goes for the plus sign:

```php
<?php

print_r(+3); // => 3
print_r(1 + +3); // => 4
```
