На базовом уровне компьютеры оперируют только числами. Для сложения двух чисел в математике мы пишем, например, `3 + 4`. В программировании — то же самое. В этом уроке разберем, как проводить арифметические операции в коде.

## Арифметика в программировании

Рассмотрим пример программы, которая складывает два числа:

```php
<?php

// Не забываем точку с запятой в конце, так как каждая строчка в коде — инструкция
3 + 4;
```

Арифметика в программировании практически не отличается от школьной. Инструкция `3 + 4;` заставит интерпретатор сложить числа и узнать результат. Эта программа будет работать, но в ней нет смысла, потому что по сути мы не даем команду интерпретатору, мы просто говорим ему «смотри, сумма трех и четырех».

В реальной работе недостаточно сообщать интерпретатору о математическом выражении. Например, при создании интернет-магазина недостаточно просить интерпретатор посчитать стоимость товаров в корзине. В этом случае нужно просить посчитать стоимость и показать цену покупателю.

Нам нужно попросить интерпретатор сложить `3 + 4` и дать команду сделать что-то с результатом. Например, вывести его на экран:

```php
<?php

// Снова не забываем точку с запятой в конце строчки
print_r(3 + 4); // => 7
```

Кроме сложения доступны следующие операции:

* `*` — умножение
* `/` — деление
* `-` — вычитание
* `%` — [остаток от деления](https://ru.wikipedia.org/wiki/Деление_с_остатком)
* `**` — возведение в степень

Эти знаки операций называют операторами.
