
Если программа на PHP написана синтаксически некорректно, то интерпретатор выводит на экран соответствующее сообщение, а также указание на файл и строчку в нём, где по его мнению произошла ошибка. _Синтаксическая ошибка_ возникает в том случае, когда код был записан с нарушением грамматических правил. В человеческих языках грамматика важна, но текст с ошибками чаще всего можно понять и прочитать. В программировании всё строго. Любое мельчайшее нарушение — и программа даже не запустится. Примером может быть забытая `;`, неправильно расставленные скобки и другие детали.

Вот пример кода с синтаксической ошибкой:

```php
<?php

print_r('Hodor')
```

Если запустить код выше, то мы увидим следующее сообщение: `$ PHP Parse error:  syntax error, unexpected end of file in /private/var/tmp/index.php on line 4`. Подобные синтаксические ошибки в PHP относятся к разряду "Parse error". Как видно, в конце приводится путь до файла и номер строчки.

С одной стороны, ошибки "Parse error" — самые простые, потому что они связаны исключительно с грамматическими правилами написания кода, а не с самим смыслом кода. Их легко исправить: нужно лишь найти нарушение в записи.

С другой стороны, интерпретатор не всегда может чётко указать на это нарушение. Поэтому бывает, что забытую скобку нужно поставить не туда, куда указывает сообщение об ошибке.
