## Зачем нужны комментарии

Кроме кода в файлах с исходным кодом могут находиться комментарии. Этот текст не является частью программы. Он нужен программистам для пометок. С их помощью добавляют пояснения, например, как работает код, какие ошибки нужно поправить или не забыть что-то позже добавить.

Комментарии в PHP бывают двух видов:

* **Однострочные комментарии** — начинаются с `//` или `#`. После этих символов может следовать любой текст, вся строка не будет анализироваться и исполняться:

  ```php
  <?php

  // For Winterfell!
  // For Lanisters!
  // Комментарий может находиться на строке после какого-нибудь кода
  print_r('I am the King'); // For Lannisters!
  ```

* **Многострочные комментарии** — начинаются с `/*` и заканчиваются на `*/`. Между ними каждая строка должна начинаться с символа `*`:

  ```php
  <?php
  /*
   * The night is dark and
   * full of terrors.
   */
  print_r('I am the King');
  ```
